#version 140
#extension GL_EXT_gpu_shader4 : enable
//Banded mosaic 3Mod01.fsh by jarble
//https://www.shadertoy.com/view/NtByzW
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define c1 vec3(1.,0.5,1.5)

vec2 rotate(vec2 v, float a) {
	float s = sin(a);
	float c = cos(a);
	mat2 m = mat2(c, -s, s, c);
	return m * v;
}

vec2 triangle_wave(vec2 a,float scale,float num){
    //a = rotate(a,num*radians(180.));
    return abs(fract((a+c1.xy)*scale)-.5);
    //return abs(fract((a+c1.xy+num)*scale)-.5);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    gl_FragColor = vec4(0.0);
    vec3 col = vec3(0.);
    float t1 = 36.*2.;
    vec2 uv = (gl_FragCoord.xy)/iResolution.y/t1/2.0;
    uv += vec2(iTime/2.0,iTime/3.0)/t1/8.0;
    float scale = c1.z;
    float p1 = 1.;
    vec2 t2 = vec2(0.);
    vec2 t3 = vec2(0.);
    for(int k = 0; k < 12; k++){
        float num = sign((uv.x-.5))/2.;

        uv += t2-float(k)/3.;
        //uv += t2-float(k)/(3.-abs(uv.x-uv.y)/8.); //this makes an even crazier pattern

        uv /= scale;
        //float num = float(k)/3.;
        t2 = -p1*triangle_wave(uv-p1*.5,scale,num);
        t3 = p1*triangle_wave(uv.yx,scale,num);
        uv = t2-t3;
        p1 *= -1.;
        float multiplier = 1.125;
        col.x = max(uv.y+uv.x-p1*col.x/multiplier,col.x/multiplier);
        col = abs(col.yzx-vec3(1.-col.x/multiplier));
    }
    gl_FragColor = vec4(col*1.5,1.0);
}




